#Include "fbgfx.bi"
Const PI As Double = 3.1415926535897932

Dim Shared terrain(320,240) As UShort
Dim As Short a,b

Function star(a As Short, b As Short, x As Short, y As Short, z As short) As Short
	Return terrain(a,b)+z/(1+Abs(x-a)+Abs(y-b))
End Function

Sub hill(x As Short, y As Short, z As Short, radius As Short=50)
	Dim As Short a,b,stx,enx,sty,eny,newz,d
	stx=x-radius : If stx<0 Then stx=0
	sty=y-radius : If sty<0 Then sty=0
	enx=x+radius : If enx>320 Then enx=320
	eny=y+radius : If eny>240 Then eny=240
	
	For a=stx To enx : For b=sty To eny
		d=sqr((x-a)^2+(y-b)^2)
		If d<radius Then
			newz=terrain(a,b)+z*cos(d/radius*(PI/2))
			If newz>1000 Then newz=1000
			If newz<0 Then newz=0
			terrain(a,b)=newz
		EndIf
	Next b : Next a
End Sub

ScreenRes 320,240,8,3,1
'init palette
For a=0 To 255 : Palette a,a,a,a : Next

ScreenSet 0,0
Print
Color 200
Print "BLACK uses arrow keys"
Print "WHITE uses WASD"
Print "ESC to quit"
Print
Color 160
Print "Guide your marbles against enemy"
Print "Collide with enemy to reduce health"
Print "Marbles in moving group restore"
Print "each other's health by mutual contact"
Print
Color 90
Print "Swarming up..."
ScreenSet 2,0
'init terrain
For a=0 To 320 : 	For b=0 To 240
	terrain(a,b)=128
Next b : Next a

'modify terrain
Randomize
For a=0 To 300
	hill(Fix(Rnd * 321),Fix(Rnd * 241),Fix(Rnd * 200)-100,Fix(Rnd * 60)+20)
Next

ScreenSet 0,0
Color 200
Print "Press any key"
Sleep

ScreenSet 2,0
Cls

'show terrain
Dim co As Short
For a=5 To 315 : 	For b=5 To 235
	co = (terrain(a+2,b+2)-terrain(a-2,b-2)) + 128
'	co = terrain(a,b)
	If co<0 Then co=0
	If co>255 Then co=255
	
	PSet (a,b),co
Next b : Next a


Dim Shared marblesonterrain(320,240) As Short
For a=0 To 320 : For b=0 To 240 : marblesonterrain(a,b)=-1 : Next b : Next a
	
'marble
Type marble
	Const inertia=1111111
	Const friction=1.1
	As Short col=0,id,alive
	As Single x,y
	As Single velocityx,velocityy
	Declare Sub dro()
	Declare Sub accel()
	Declare Sub move()
	Declare Constructor
End Type
Sub marble.dro()
	If this.alive <= 0 Then Return
	PSet(this.x,this.y),this.col
	PSet(this.x-1,this.y),(this.col+128)/2
	PSet(this.x,this.y-1),(this.col+128)/2
	PSet(this.x+1,this.y),(this.col+128)/2
	PSet(this.x,this.y+1),(this.col+128)/2
End Sub
Sub marble.accel()
	If this.alive <=0 Then Return
	Dim a As Byte
	Dim As Integer zx=0,zy=0
	For a=1 To 2
		zx+=(terrain(this.x+a,this.y)-terrain(this.x-a,this.y)) '? these 2 rows should be
		zy+=(terrain(this.x,this.y+a)-terrain(this.x,this.y-a)) '? sufficient?
		zx-=(terrain(this.x-a,this.y)-terrain(this.x+a,this.y))
		zy-=(terrain(this.x,this.y-a)-terrain(this.x,this.y+a))
	Next
	this.velocityx=this.velocityx+(zx/this.inertia)
	this.velocityy=this.velocityy+(zy/this.inertia)
End Sub

Dim Shared mars(1999) As marble
Dim Shared marsw(1999) As marble
For a=0 To UBound(marsw) : marsw(a).col=255 : Next 

Sub marble.move()
	If this.alive <=0 Then marblesonterrain(this.x,this.y)=-1 : Return 
	Dim As Short oldx,oldy
	oldx=this.x : oldy=this.y	
	this.x+=velocityx
	this.y+=velocityy
	If this.x<5 Then this.x=5 : velocityx=velocityx*-1
	If this.x>315 Then this.x=315 : velocityx=velocityx*-1
	If this.y<5 Then this.y=5 : velocityy=velocityy*-1
	If this.y>235 Then this.y=235 : velocityy=velocityy*-1
	If marblesonterrain(this.x,this.y)<>-1 And  marblesonterrain(this.x,this.y)<>this.id Then
		velocityx=velocityx*-.5
		velocityy=velocityy*-.5
		If (this.id<2000 And marblesonterrain(this.x,this.y)<2000) Or _
		(this.id>=2000 And marblesonterrain(this.x,this.y)>=2000) Then
			this.alive+=1
			If this.alive>5 Then this.alive=5
		Else
			this.alive-=1
			If marblesonterrain(this.x,this.y)>=2000 Then
				marsw(marblesonterrain(this.x,this.y)-2000).alive-=1
			Else
				mars(marblesonterrain(this.x,this.y)).alive-=1
			EndIf
			If this.alive<=0 Then
				ScreenSet 2,0 'dead become part of the background
				PSet (this.x,this.y),(this.col+Point(this.x,this.y)*2)/3
				ScreenSet 1,0
			EndIf
		EndIf 
		this.x=oldx
		this.y=oldy
	Else
		marblesonterrain(oldx,oldy)=-1
		marblesonterrain(this.x,this.y)=this.id
	EndIf
	velocityx=velocityx/this.friction
	velocityy=velocityy/this.friction
End Sub
Constructor marble
	Static id As Short=0
	this.id=id
	id+=1
	this.alive=5
	this.x=Fix(Rnd * 310)+5
	this.y=Fix(Rnd * 230)+5
	this.velocityx=0
	this.velocityy=0
End Constructor


ScreenSet 1,0

#Include "dragons.bas"

Dim dr As dragon=dragon(220,140,-1)
Dim dr2 As dragon=dragon(100,100,0)



Dim keypressed As String
Dim Shared As Double movetimer
movetimer=Timer
Do 
	keypressed=InKey
	If Timer-movetimer>.01 Then
		movetimer=Timer
		If MultiKey(FB.SC_LEFT) Then dr.rotate(3) 'mars(a).velocityx-=.2
		If MultiKey(FB.SC_RIGHT) Then dr.rotate(-3) 'mars(a).velocityx+=.2
		If MultiKey(FB.SC_UP) Then dr.move(3) 'mars(a).velocityy-=.2
		If MultiKey(FB.SC_A) Then dr2.rotate(3) 'marsw(a).velocityx-=.2
		If MultiKey(FB.SC_D) Then dr2.rotate(-3) 'marsw(a).velocityx+=.2
		If MultiKey(FB.SC_W) Then dr2.move(3) 'marsw(a).velocityy-=.2
		For a = 0 To UBound(mars)
			If MultiKey(FB.SC_DOWN) Then
				mars(a).velocityy+=Cos(pi+(dr.direction+128)/256*2*pi)*10/Sqr(1+(mars(a).y-dr.p.y)^2+(mars(a).x-dr.p.x)^2)
				mars(a).velocityx+=Sin(pi+(dr.direction+128)/256*2*pi)*10/Sqr(1+(mars(a).y-dr.p.y)^2+(mars(a).x-dr.p.x)^2)
			EndIf
			If MultiKey(FB.SC_S) Then
				marsw(a).velocityy+=Cos(pi+(dr2.direction+128)/256*2*pi)*10/Sqr(1+(marsw(a).y-dr2.p.y)^2+(marsw(a).x-dr2.p.x)^2)
				marsw(a).velocityx+=Sin(pi+(dr2.direction+128)/256*2*pi)*10/Sqr(1+(marsw(a).y-dr2.p.y)^2+(marsw(a).x-dr2.p.x)^2)
			EndIf
			mars(a).accel()
			marsw(a).accel()
			If a Mod 2 = 0 Then mars(a).move() : marsw(a).move() Else marsw(a).move() : mars(a).move()
		Next
	EndIf
	ScreenCopy 2,1
	For a = 0 To UBound(mars)
		mars(a).dro()
		marsw(a).dro()
	Next 
'	ScreenSync
	dr.draw():dr2.draw()
	ScreenCopy 1,0
	Sleep 10
Loop While keypressed<>Chr(27)
