#include "fbgfx.bi"
Using fb

const TRUE=-1
const FALSE=0
Dim Shared As String nextvariation, help 
Dim Shared As UByte playabletiles, numberoftiles
Dim Shared As Short columns=1, rows=1
Dim Shared As Byte gravity,randominputs,randomgoals,showscore=FALSE,wrap=TRUE
dim shared score as short=0
ReDim Shared tilesfiles(0) As String
Dim Shared speed as single=3
ReDim Shared randomtable() As UByte
Dim Shared tim as Double

Declare Sub loadgame(filename As String)
Declare Sub loadTiles(increment As Byte=1)
Declare Sub initplayfield()

Function asctonumber(ch As UByte) As UByte
	If ch=46 Then : Return 0
	ElseIf ch=33 Then : Return 254 'start=!=254
	ElseIf ch=Asc("@") Then : Return 253 'exit=@=253
	ElseIf ch>=48 And ch<=57 Then : Return ch-48
	ElseIf ch>=65 And ch<=90 Then : Return ch-65+10
	ElseIf ch>=97 And ch<=122 Then : Return ch-97+36
	Else : Return 255
	End If
End Function

Function getImgWidth(filename As String) As Short
	Open filename For Input As #2
	If Err>0 Then Return 0
	Dim w As Integer
	Get #2,19,w
	Close #2
	Return w
End Function

ReDim Shared inputsindex(0) As UByte 'pokazuje krajeve
ReDim Shared inputs(0,2) As UByte
ReDim Shared goals(0,2) As UByte
Sub loadshapes(shapes() As UByte, filename As String, index As Byte=FALSE)
	Dim l as String
	Dim currentpoint As Short=0
	Dim As UByte a,b=0,currentshape=0
	Do Until l="}" Or Eof(1)
		Line Input #1,l
		If l="" Then 
			b=0
			shapes(currentpoint,0)=255
			shapes(currentpoint,1)=255
			shapes(currentpoint,2)=255 'end shape
			If index Then
				ReDim Preserve inputsindex(currentshape)
				inputsindex(currentshape)=currentpoint
				currentshape+=1
			End if
			currentpoint+=1
			ReDim Preserve shapes(currentpoint,2)
		ElseIf l<>"}" Then
			For a=0 To Len(l)-1
				shapes(currentpoint,0)=a
				shapes(currentpoint,1)=b
				If l[a]=46 Then : shapes(currentpoint,2)=0
				Else : shapes(currentpoint,2)=asctonumber(l[a])
				End If
				currentpoint+=1
				ReDim Preserve shapes(currentpoint,2)
			Next
			b+=1
		EndIf
	Loop
	shapes(currentpoint,0)=255
	shapes(currentpoint,1)=255
	shapes(currentpoint,2)=255 'end shape
	If index Then
		ReDim Preserve inputsindex(currentshape)
		inputsindex(currentshape)=currentpoint
	End If
End Sub



Declare Sub gameOver()

dim shared playfield(0 to columns-1,0 to rows-1) as UByte
dim shared originalplayfield(0 to columns-1,0 to rows-1) as UByte

type block
	declare constructor
	declare sub init()
	Declare sub update(justerase As Byte = FALSE)
	Declare sub drop()
	Declare Function move(as Byte,as Byte=0,As UByte=0) As Byte
	As UByte typ
private:
	Declare Function isblocked(x as Byte, y As Byte=0, typ As UByte=0, mode As Byte=FALSE) As Byte
	As Short x,y,oldx,oldy
	As UByte oldtyp
end type

ReDim Shared nextshape() As UByte

Function block.isblocked(x as Byte, y As Byte=0, typ As UByte=0, mode As Byte=FALSE) As Byte
	Dim As Short strt, stp, a
	Dim As Byte failed

	If typ=1 Then strt=0 Else strt=inputsindex(typ-1-1)+1 'preskace se ona 255 tacka
	stp=inputsindex(typ-1)-1 'izostavlja se ona 255 tacka
	'mode=true = ispituje se origin
	For a = strt To stp
		failed=inputs(a,2)<>0 And _
		playfield(x+inputs(a,0),y+inputs(a,1))<>254 And _
		playfield(x+inputs(a,0),y+inputs(a,1))<>253
		If Not mode Then failed=failed And playfield(x+inputs(a,0),y+inputs(a,1))<>0
		failed=failed Or y+inputs(a,1)>=rows _
		Or y+inputs(a,1)<0 _
		Or x+inputs(a,0)>=columns _
		Or x+inputs(a,0)<0
		If failed Then Exit For
	Next
	Return failed
End Function


Sub block.init()
	If randominputs Then 'permutovati brojeve od 1 do playabletiles
		Dim a As UByte
		ReDim randomtable(playabletiles) As UByte
		For a = 1 To playabletiles
			randomtable(a)=fix(rnd*playabletiles)+1
		Next
	EndIf

	Type xy
		As UByte x,y
	End Type
	ReDim startpositions(0) As xy
	Dim posnumber As UShort=0
	Dim As UShort x,y
	Dim starttyp As UByte
	this.typ=fix(rnd*(ubound(inputsindex)+1))+1
	starttyp=this.typ
	Do
	   for y=0 to rows-1 : for x=0 to columns-1
	   	If originalplayfield(x,y)=254 Then
		   	If Not this.isblocked(x,y,this.typ,TRUE) Then  'dodaj na listu
					ReDim Preserve startpositions(posnumber) As xy
					startpositions(posnumber)=Type(x,y)
					posnumber+=1
		   	EndIf
	   	EndIf
	   next x: next y
	   If posnumber=0 Then
	   	this.typ=nextshape(this.typ)
			If this.typ=starttyp Then
				gameOver()
				Return
			EndIf
	   EndIf
	Loop Until posnumber>0
	posnumber=fix(rnd*posnumber)
	this.x=startpositions(posnumber).x
	this.y=startpositions(posnumber).y
	this.oldx=this.x
	this.oldy=this.y
	this.oldtyp=this.typ
End Sub

Constructor block 
	'constructor bi se pokretao kod samog deklarisanja, pre playfielda
End Constructor

Function getshapewidthheight(typ As UByte,geth As Byte = FALSE) As Short
	Dim As Short strt, stp, a, maxwidth=0, maxheight=0
	
	If typ=1 Then strt=0 Else strt=inputsindex(typ-1-1)+1 'preskace se ona 255 tacka
	stp=inputsindex(typ-1)-1 'izostavlja se ona 255 tacka
	For a = strt To stp
		If maxwidth<inputs(a,0) Then maxwidth=inputs(a,0) 
		If maxheight<inputs(a,1) Then maxheight=inputs(a,1) 
	Next
	If geth Then Return maxheight
	Return maxwidth
End Function



Function block.move(x as Byte, y As Byte=0, typ As UByte=0) As Byte 'successfull?true/false
	Dim As Byte dw,dh
	If typ=0 Then
		 typ=this.typ
	Else
		'!centriranje
		dw=(getshapewidthheight(this.typ)-getshapewidthheight(typ)) / 2
		If gravity Then
			dh=0
		Else
			dh=(getshapewidthheight(this.typ,TRUE)-getshapewidthheight(typ,TRUE)) / 2
		EndIf
	EndIf
	this.oldx=this.x
	this.oldy=this.y
	this.oldtyp=this.typ
	this.update(TRUE) 'just erase oldx i oldy

	this.x=x + this.x + dw 
	this.y=y + this.y + dh 

	Dim As Byte failed
	failed=this.isblocked(this.x,this.y,typ)
	If failed Then
		this.x=this.oldx
		this.y=this.oldy
		this.typ=this.oldtyp
	Else
		this.typ=typ
	EndIf
	this.update()
	Return Not failed

End Function

Sub markshape(shapestart As Short,shapeend As Short,x As Short,y As Short)
	Dim As Short mx,my,q
	For q=shapestart To shapeend-1
		mx=x-goals(q,0)
		my=y-goals(q,1)
		If goals(q,2)<>0 And playfield(mx,my)<100 Then
			playfield(mx,my)+=100
		End if
	Next
End Sub


function matchshape(x As Short,y As Short) as Byte
	dim as Byte fullshape,foundshape=FALSE
	Dim As Short mx,my,shapestart=0,p=0,q
	Dim a As UByte
	Dim goalscolors(100) As UByte 'za randomgoals '!max 100 randomgolova
	fullshape=true
	For p=0 To UBound(goals)
		If goals(p,0)=255 And goals(p,1)=255 And goals(p,2)=255 Then '255,255,255=end
			If fullshape=TRUE Then
				markshape(shapestart,p,x,y)
				foundshape=TRUE
			End If
			shapestart=p+1
			fullshape=TRUE
			For a=0 To UBound(goalscolors) : goalscolors(a)=0 : Next a
		Else
			mx=x-goals(p,0)
			my=y-goals(p,1)
			If mx<0 Or mx>columns-1 Or my<0 Or my>rows-1 Then
				fullshape=FALSE
			ElseIf goals(p,2)=255 Then '255=joker
				fullshape = fullshape And _
				(playfield(mx,my)<>0) And _
				(playfield(mx,my)<>254) And _
				(playfield(mx,my)<>253)
			ElseIf goals(p,2)<>0 Then
				If randomgoals Then
					If goalscolors(goals(p,2))=0 Then
						If (playfield(mx,my)<>0) And _
							(playfield(mx,my)<>254) And _
							(playfield(mx,my)<>253)Then  
							goalscolors(goals(p,2))=playfield(mx,my)
						Else
							fullshape=FALSE
						EndIf
					EndIf  
					fullshape = fullshape And (playfield(mx,my)=goalscolors(goals(p,2)) _
					Or playfield(mx,my)=goalscolors(goals(p,2))+100)
				Else	
					fullshape = fullshape And (playfield(mx,my)=goals(p,2) _
					Or playfield(mx,my)=goals(p,2)+100)
				EndIf
			End If
		End If 
	Next
	Return foundshape
end function

sub checksituation()
   dim as byte x,y,gap,removed=false,scoremulti=0,existsnextvariation=FALSE, gotonextvariation=TRUE
   for y=0 to rows-1 : for x=0 to columns-1
       if matchshape(x,y) then scoremulti+=1
   next x: next y
	If gravity Then 'remove >100 (marked shapes)
	   for x=0 to columns-1
	       gap=0
	       for y=rows-1 to 0 step -1
	            if playfield(x,y)>100 And playfield(x,y)<>254 And playfield(x,y)<>253 Then
	            	gap+=1
	            Else
						If playfield(x,y)=254 Then
							If originalplayfield(x,y)=254 Or originalplayfield(x,y)=253 Then 
								playfield(x,y+gap)=originalplayfield(x,y) 
							Else
								playfield(x,y+gap)=0
							EndIf 
						Else playfield(x,y+gap)=playfield(x,y)
						End If
	            End if
	            If y<gap Then 
	            	If originalplayfield(x,y)=254 Or originalplayfield(x,y)=253 Then
	            		playfield(x,y)=originalplayfield(x,y)
	            	Else
	            		playfield(x,y)=0
	            	EndIf
	            EndIf
	        next y
	        removed=removed or gap>0
	    next x
    if removed then checksituation()
	Else 'no gravity
		for y=0 to rows-1 : for x=0 to columns-1
			if playfield(x,y)>100 And playfield(x,y)<>254 And playfield(x,y)<>253 Then
				If originalplayfield(x,y)=254 Or originalplayfield(x,y)=254 Then
					playfield(x,y)=originalplayfield(x,y)
				Else
					playfield(x,y)=0
				EndIf
			EndIf
		next x: next y
	EndIf
	score+=scoremulti*10
	'proveri da li je pokriven exit
	for y=0 to rows-1 : for x=0 to columns-1
		If originalplayfield(x,y)=253 Then
			existsnextvariation=TRUE
			If playfield(x,y)=253 Then gotonextvariation=FALSE
		EndIf
	next x: next y
	If existsnextvariation And gotonextvariation Then
		loadgame("variations/"+nextvariation)
		loadTiles(0)
		speed=3
		initplayfield()
	EndIf
end sub

Sub block.update(justerase As Byte =FALSE)
	Dim As Short strt, stp, a
	
	If this.oldtyp=1 Then strt=0 Else strt=inputsindex(this.oldtyp-1-1)+1 'preskace se ona 255 tacka
	stp=inputsindex(this.oldtyp-1)-1 'izostavlja se ona 255 tacka
	For a = strt To stp
		If inputs(a,2)<>0 Then 
			If originalplayfield(this.oldx+inputs(a,0),this.oldy+inputs(a,1))=254 Or _
				originalplayfield(this.oldx+inputs(a,0),this.oldy+inputs(a,1))=253 Then
				playfield(this.oldx+inputs(a,0),this.oldy+inputs(a,1)) = _
				originalplayfield(this.oldx+inputs(a,0),this.oldy+inputs(a,1)) 'cuvamo "start" pri pomeranju
			Else
				playfield(this.oldx+inputs(a,0),this.oldy+inputs(a,1))=0
			EndIf
		EndIf
	Next 
	If justerase=FALSE Then
		If this.typ=1 Then strt=0 Else strt=inputsindex(this.typ-1-1)+1 'preskace se ona 255 tacka
		stp=inputsindex(this.typ-1)-1 'izostavlja se ona 255 tacka
		For a = strt To stp
			If inputs(a,2)<>0 Then 
				If randominputs Then
					playfield(this.x+inputs(a,0),this.y+inputs(a,1))=randomtable(inputs(a,2))
				Else
					playfield(this.x+inputs(a,0),this.y+inputs(a,1))=inputs(a,2)
				EndIf
			EndIf
		Next 	
	EndIf


'	playfield(this.oldx,this.oldy)=0
'	playfield(this.x,this.y)=this.typ

End Sub

Sub block.drop()
	If Not this.move(0,1) Then
		checksituation()
		this.init()
	EndIf
/'
nije mi jasno kako checksituation funkcionise bez ovoga:
		this.update()
'/
End Sub


dim keypress as string

sub initplayfield
	ReDim playfield(0 to columns-1,0 to rows-1) As UByte
   dim as ubyte x,y
   for y=0 to rows-1 : for x=0 to columns-1
       playfield(x,y)=originalplayfield(x,y)
   next x : next y
end sub


Dim Shared tilewidth As Short
Dim Shared tilesimg As Any Ptr
Dim Shared scoreimg As Any Ptr

Declare Sub drawplayfield()

Sub loadTiles(increment As Byte=1)
	Static tilesetnum As UByte
	tilesetnum+=increment
	If tilesetnum>UBound(tilesfiles) Then tilesetnum=0
	If tilesetnum<0 Then tilesetnum = UBound(tilesfiles) 

	Dim tilesfile As String
	tilesfile=tilesfiles(tilesetnum)
		
	tilewidth = getImgWidth(tilesfile)
	If showscore Then
		ScreenRes tilewidth*columns,tilewidth*rows+16,16,2,&h08
	Else
		ScreenRes tilewidth*columns,tilewidth*rows,16,2,&h08
	EndIf
	ScreenSet 0,1
	
	tilesimg = ImageCreate(tilewidth, tilewidth*(3+numberoftiles))
	BLoad tilesfile, tilesimg
	scoreimg = ImageCreate(122,20)
	BLoad "brojke.bmp", scoreimg
	drawplayfield()
End Sub

dim shared blok as block 

Sub drawscore
 'ScreenRes tilewidth*columns,tilewidth*rows,16,2,&h08
	Dim As UByte a,digit
	Dim As Byte numberstarted=FALSE
/'
	Static xpx As UByte = 0
	Line (0,0)-(xpx,14),RGB(0,0,0),bf
	xpx=0
	For a=0 To 8 'max 9 digits
		digit=Fix((score Mod 10^(9-a)) / 10^(8-a))
		numberstarted=numberstarted Or digit>0
		If numberstarted Then
			If digit=1 Then
				Put (1+xpx,1),scoreimg,(13,0)-(17,14),PSet
				xpx+=5
			ElseIf digit=0 Then
				Put (1+xpx,1),scoreimg,(0,0)-(12,14),PSet
				xpx+=13
			Else
				Put (1+xpx,1),scoreimg,(-8+digit*13,0)-(-8+12+digit*13,14),PSet
				xpx+=13
			EndIf
		EndIf
	Next
'/
	Dim xpx As UShort = tilewidth*columns
	Line(0,0)-(xpx,16),RGB(0,0,0),BF
	For a=0 To 9 'max 10 digits - traze se otpozadi
		If 10^a > score Then Exit For
		digit=Fix((score Mod 10^(a+1)) / 10^a)
		If digit=1 Then
			xpx-=5
			Put (xpx,1),scoreimg,(13,0)-(17,14),PSet
		ElseIf digit=0 Then
			xpx-=13
			Put (xpx,1),scoreimg,(0,0)-(12,14),PSet
		Else
			xpx-=13
			Put (xpx,1),scoreimg,(-8+digit*13,0)-(-8+12+digit*13,14),PSet
		EndIf
	Next
End Sub

Sub drawplayfield
	Dim As Short offsetx=0,offsety=0,offsetpx=0,offsetpy=0 
	If showscore Then offsetpy=16
	dim as ubyte x,y,t
	for y=0 to rows-1 : for x=0 to columns-1
		If playfield(x,y)=0 Then : t=0
		ElseIf playfield(x,y)=254 Then : t=1
		ElseIf playfield(x,y)=253 Then : t=2
		Else : t=playfield(x,y)+2
		End If
		Put (offsetpx+(offsetx+x)*tilewidth, offsetpy+(offsety+y)*tilewidth), _
		tilesimg,(0,t*tilewidth) - Step(tilewidth-1,tilewidth-1),PSet
	next x: next y
	If showscore Then drawscore
	
	ScreenSync
	ScreenCopy
End Sub


Sub loadtilesets()
	Dim l As String, n As UByte=0
	Do Until l="}" Or Eof(1)
		Line Input #1,l
		ReDim Preserve tilesfiles(n)
		tilesfiles(n)=l
		n+=1
	Loop
	ReDim Preserve tilesfiles(n-2)
End Sub

Sub loadcycle()
	Dim l As String, n As UByte
	Line Input #1,l
	ReDim nextshape(Len(l)) As UByte 
	For n=0 To Len(l) 'nextshape(0) se ne koristi
		nextshape(n+1)=asctonumber(l[n])
	Next
End Sub

Sub loadplayfield()
	columns=0 : rows=0
	Dim l As String, n As UByte
	Dim position As Integer = Seek(1)
	Dim As Short a,b=0
	Do Until l="}" Or Eof(1)
		rows+=1
		Line Input #1,l
		If Len(l)>columns Then columns=Len(l)
	Loop
	ReDim originalplayfield(0 to columns-1,0 to rows-1) as UByte
	rows-=1
	Seek #1,position
	l=""
	Do Until l="}" Or Eof(1)
		b+=1
		Line Input #1,l
		For a=0 To Len(l)-1
/'
			If l[a]=46 Then : originalplayfield(a,b-1)=0
			Else : originalplayfield(a,b-1)=asctonumber(l[a])
			End If
'/
			n=asctonumber(l[a])
			originalplayfield(a,b-1)=n
			If n>numberoftiles And n<100 Then numberoftiles=n 
		Next
	Loop
	If playabletiles>numberoftiles Then numberoftiles=playabletiles
End Sub


Sub loadsettings()
	gravity=FALSE
	randominputs=FALSE
	randomgoals=FALSE
	Dim l As String
	Do Until l="}" Or Eof(1)
		Line Input #1,l
		gravity=gravity Or l="gravity"		
		randominputs=randominputs Or l="randominputs"		
		randomgoals=randomgoals Or l="randomgoals"
		If Left(l,6)="tiles:" Then playabletiles=CInt(Mid(l,7))
	Loop
End Sub


Sub loadgame(filename As String)
	Dim l As String
	Open filename For Input As #1
	If Err>0 Then Print "Error opening the file":End
	Do
		Line Input #1,l
		Select Case l
			Case "Title {"
				Line Input #1,l
				WindowTitle(l)
			Case "Settings {"
				loadsettings()
			Case "Next {"
				Line Input #1,nextvariation
			Case "Tilesets {"
				loadtilesets()
			Case "Playfield {"
				loadplayfield()
			Case "Input {"
				loadshapes(inputs(),filename,TRUE)
			Case "Cycle {"
				loadcycle()
			Case "Goals {"
				loadshapes(goals(),filename)	
			Case "Help {"
				Line Input #1,help
		End Select
	Loop Until Eof(1)
	Close #1
End Sub



Sub gameRestart()
	speed=3
	initplayfield()	
	blok.init()
	blok.update()
	drawplayfield()
End Sub


Function isin(xx As Short,yy As Short,x As Short,y As Short,w As UShort=50,h As UShort=50) As Byte
		Dim in As Byte = TRUE
		in=in And xx>=x And xx<=x+w
		in=in And yy>=y And yy<=y+h
		Return in
End Function




Sub togglescore()
	showscore=Not showscore
	If showscore Then
		ScreenRes tilewidth*columns,tilewidth*rows+16,16,2,&h08
	Else
		ScreenRes tilewidth*columns,tilewidth*rows,16,2,&h08
	EndIf
   ScreenSet 0,1
	drawplayfield()
End Sub


Sub openmenu()
	Dim e As EVENT
	Dim As Integer x, y, pressed
	
	Dim As Integer w,h
	ScreenInfo(w,h)
	
	Dim menuimg As Any Ptr
	ScreenRes 150,150,16,1,&h08	
	menuimg = ImageCreate(150,150)
	BLoad "menu.bmp", menuimg
	Put(0,0),menuimg,PSet	
	dim keypress as string
	Do 
		keypress=InKey
		Select Case keypress
			Case "t"
				loadTiles(1)
				ImageDestroy(menuimg)
				Exit Sub
			Case "+"	
				speed=speed/1.5
				Exit Do
			Case "s"
				togglescore()
				ImageDestroy(menuimg)
				Exit Sub
			Case chr(255)+";" 'F1
				shell("viewer.exe "+ExePath+"/variations/"+help)
			Case chr(255)+"<" 'F2
				score=0
				gameRestart()
				Exit Do
			Case "l"
				Run("loader.exe")
		End Select
		If (ScreenEvent(@e)) Then
	        Select Case e.type
	        Case EVENT_MOUSE_BUTTON_PRESS
	            pressed = e.button=1
					If e.button=2 Then Exit Do
					If pressed Then
						GetMouse(x,y)
						If isin(x,y,0,0) Then 'help
							shell("viewer.exe "+ExePath+"/variations/"+help)
						ElseIf isin(x,y,100,0) Then 'quit
							ImageDestroy(menuimg)
							End
						ElseIf isin(x,y,50,50) Then 'tiles
							loadTiles(1)
							ImageDestroy(menuimg)
							Exit Sub
						ElseIf isin(x,y,0,50) Then 'speed
							speed=speed/1.5
							Exit Do
						ElseIf isin(x,y,100,50) Then 'score
							togglescore()
							ImageDestroy(menuimg)
							Exit Sub
						ElseIf isin(x,y,50,0) Then 'restart
							score=0
							gameRestart()
							Exit Do
						ElseIf isin(x,y,0,100) Then 'load
							Run("loader.exe")
						End If
					End If
	        Case EVENT_MOUSE_BUTTON_RELEASE
	            pressed = 0
	        Case EVENT_MOUSE_MOVE
	            If (pressed) Then
						ScreenControl GET_WINDOW_POS, x, y
						ScreenControl SET_WINDOW_POS, x + e.dx, y + e.dy
	            End If
	        End Select
		End If
		
	Loop Until keypress=Chr(27)
	ImageDestroy(menuimg)

	ScreenRes w,h,16,2,&h08
	drawplayfield()
End Sub

Sub windowmouse
	Dim e As EVENT
	Dim As Integer x, y
	Static pressed As Integer=0
	If (ScreenEvent(@e)) Then
		Select Case e.type
		Case EVENT_MOUSE_BUTTON_PRESS
			pressed = e.button=1  
			If e.button=2 Then openmenu()
		Case EVENT_MOUSE_BUTTON_RELEASE
			pressed = 0
		Case EVENT_MOUSE_MOVE
			If (pressed) Then
				ScreenControl GET_WINDOW_POS, x, y
				ScreenControl SET_WINDOW_POS, x + e.dx, y + e.dy
			End If
		End Select
	End If
End Sub


Sub gameOver()
	Dim As Short offsety=0, offsety2=0
	Dim As Byte inkeyemptied=FALSE, scoredrawn=FALSE
	Dim tim2 As Double
	scoredrawn=showscore
	If showscore Then offsety=16
	offsety2=offsety
	Dim keypress as string
	tim=Timer()
	tim2=Timer()
	Do
		If Timer-tim2>0.5 Then 
			keypress=InKey
		Else
			While InKey<>"" : Wend 'prazni inkey tokom prvih pola sekunde
		EndIf
		
		If offsety2<tilewidth*rows+offsety-6 Then
			If Timer-tim>0.03 Then
				tim=Timer()
				Line (0,offsety2)-(tilewidth*columns,offsety2+6),RGB(0,0,0),BF
				Put(tilewidth*columns/2-47/2,offsety2+1),scoreimg,(52,15)-(99,19),PSet
				offsety2+=1
				ScreenSync
				ScreenCopy
			EndIf
		EndIf
		If offsety2>20 And Not scoredrawn Then
			drawscore()
			scoredrawn=TRUE
		EndIf
		
		windowmouse()
	Loop Until keypress<>""
	
	Cls
	score=0
	gameRestart()
End Sub



Randomize
If Command="" Then End
loadgame(Command)
loadTiles(0)
score=0
gameRestart()

tim=timer()
do
	keypress=InKey
	if keypress=chr(255)+"K" then 
		blok.move(-1)
		drawplayfield()
	ElseIf keypress=chr(255)+"M" then 
		blok.move(1)
		drawplayfield()
	ElseIf keypress=" " Then
		blok.move(0,0,nextshape(blok.typ)) 'cycle
		drawplayfield()
	ElseIf keypress=chr(255)+"H" Then 'gore=move up or rotate
		If gravity Then
	    	blok.move(0,0,nextshape(blok.typ)) 'cycle
		Else
			blok.move(0,-1)
		EndIf
    	drawplayfield()
	ElseIf keypress=chr(255)+"P" Then 'dole
		If gravity Then
			score+=1
			blok.drop()
			tim=timer()
			blok.update()
		Else
			blok.move(0,1)
		EndIf
		drawplayfield()
	ElseIf keypress="t" Or keypress="T" Then
		loadTiles(1)
	ElseIf keypress=Chr(13) Then 'enter=fix or drop
		If gravity Then
			Do : score+=1 : Loop While blok.move(0,1)
		EndIf			
		checksituation()
		blok.init()
		blok.update()
		drawplayfield()
	ElseIf keypress="s" Or keypress="S" then 'score
		togglescore()
	ElseIf keypress="l" Or keypress="L" then 'load
		Run("loader.exe")
	ElseIf keypress=chr(255)+";" then 'F1
		shell("viewer.exe "+ExePath+"/variations/"+help)
	ElseIf keypress=chr(255)+"<" then 'F2
		score=0
    	gameRestart()
	ElseIf keypress="+" Then 'speed+
		speed=speed/1.5
	EndIf
	if gravity And timer-tim>speed then
        speed=speed/1.003
        blok.drop()
        blok.update()
        drawplayfield()
        tim=timer()
	end If
	windowmouse()
loop until keypress=chr(27)
ImageDestroy(tilesimg)
ImageDestroy(scoreimg)
